

#include <sys/io.h>
#include <unistd.h>
#include <iostream>
#include <stdlib.h>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "libBSDF.h"
#include "bsdf.h"
#include "bsdf_m.h"
#include "bsdf_t.h"
#include "ezxml.h"
#include "hilbert.h"

#define	_USE_MATH_DEFINES

using namespace std;

JNIEXPORT jlong JNICALL Java_libBSDF_Load (JNIEnv *env, jclass c, jstring fname)
{  
const SDData *myBSDF;
const char *filename = env->GetStringUTFChars( fname, 0);
myBSDF=SDcacheFile(filename);
env->ReleaseStringUTFChars( fname, filename);
return ((jlong)(intptr_t)myBSDF);
}


JNIEXPORT void JNICALL Java_libBSDF_Free
  (JNIEnv *env, jclass c){
SDfreeCache(NULL);
}

JNIEXPORT jfloat JNICALL Java_libBSDF_hemispherical
  (JNIEnv *env, jclass c, jdoubleArray invec, jdoubleArray outvec, jlong lp)
{
	long mylp = (long)lp;
	const SDData *myBSDF = (SDData*)mylp;

	jdouble* inelms=env->GetDoubleArrayElements( invec,0);
	jdouble* outelms=env->GetDoubleArrayElements( outvec,0);
	SDValue *tmp ;
	
	int inFront = (inelms[2] > 0);
	int outFront = (outelms[2] > 0);
	if (inFront & outFront) {
		*tmp = myBSDF->rLambFront;
	} else if (!(inFront | outFront)) {
		*tmp = myBSDF->rLambBack;
	} else /* inFront ^ outFront */ {
		*tmp = myBSDF->tLamb;
	}
	return (jfloat)tmp->cieY;

}

JNIEXPORT jfloat JNICALL Java_libBSDF_getBSDFvalue
  (JNIEnv *env, jclass c, jdoubleArray invec, jdoubleArray outvec, jlong lp)
{
	long mylp = (long)lp;
	const SDData *myBSDF = (SDData*)mylp;

	SDValue ourResult;
	jdouble* inelms=env->GetDoubleArrayElements( invec,0);
	jdouble* outelms=env->GetDoubleArrayElements( outvec,0);
	const FVECT ina={inelms[0],inelms[1],inelms[2]};
	const FVECT outa={outelms[0],outelms[1],outelms[2]};
	SDevalBSDF(&ourResult, outa, ina, myBSDF);
	env->ReleaseDoubleArrayElements(invec, inelms, 0);
	env->ReleaseDoubleArrayElements(outvec, outelms, 0);
	double result = (&ourResult)->cieY;
	return ( (jfloat)result );
}

