/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.xml.XMLElement;

public class BSDFViewer
extends PApplet {
    String filename = "No File Loaded";
    String savefile;
    String Wavelength = "";
    String Direction = "";
    String dataformat = "LBNL/Full Klems";
    String projection = "equidistant";
    PFont buttonfont;
    PFont captionfont;
    PFont helpfont;
    PFont loadingfont;
    PImage logo;
    int overpatch;
    int loading = 0;
    int numBRTDF = 1;
    int curBRTDF = 1;
    boolean fileload = false;
    float hemispherical = 0.0f;
    float patchval = 1000.0f;
    XMLElement xml;
    String[] fronttrans;
    long myBSDFaddress;
    boolean dispNumbers = false;
    boolean scaleLog = true;
    boolean showHelp = false;
    TextField scalemax = new TextField("100", 4);
    TextField scaledecades = new TextField("4", 1);
    TextField scalemin = new TextField("0", 4);
    Panel decPanel = new Panel();
    Panel inputPanel = new Panel();
    Panel minPanel = new Panel();
    int smX = 5;
    int smY = 134;
    int sX = 1100;
    int sY = 100;
    int ihX = 220;
    int ihY = 480;
    int ihW = 420;
    int ihH = 420;
    int ohX = 750;
    int ohY = 375;
    int ohW = 620;
    int ohH = 620;
    int incident = 1;
    int incidentx = this.ihX;
    int incidenty = this.ihY;
    int outZ = 1;
    int inZ = 1;
    double[] invec = new double[]{0.0, 0.0, 1.0};
    float[] inangle = new float[]{0.0f, 0.0f};
    boolean error = false;
    String ErrMsg;
    RArrowButton RA;
    LArrowButton LA;
    TextButton loadBut;
    TextButton saveBut;
    TextButton hideBut;
    TextButton linearBut;
    TextButton logBut;
    TextButton equiBut;
    TextButton orthoBut;
    ChangeTextButton helpBut;
    ChangeTextButton patchBut;
    int ndivs = 145;

    public void setup() {
        this.size(1180, 700);
        this.smooth();
        this.noLoop();
        this.buttonfont = this.loadFont("Candara-Bold-16.vlw");
        this.captionfont = this.loadFont("Candara-12.vlw");
        this.helpfont = this.loadFont("Noteworthy-Bold-14.vlw");
        this.loadingfont = this.loadFont("Candara-Bold-32.vlw");
        this.logo = this.loadImage("Logo.png");
        int n = this.color(175);
        int n2 = this.color(125);
        this.loadBut = new TextButton(5, 5, 160, 25, n, n, "Load a BSDF XML file", this.buttonfont);
        this.saveBut = new TextButton(5, 35, 160, 25, n, n, "Save Image", this.buttonfont);
        this.helpBut = new ChangeTextButton(5, 65, 145, 18, n, n, "Show Help", "Hide Help", this.captionfont);
        this.patchBut = new ChangeTextButton(5, 88, 145, 18, n, n, "Show Patch Numbers", "Hide Patch Numbers", this.captionfont);
        this.equiBut = new TextButton(5, 111, 65, 18, n, n2, "Equidistant", this.captionfont);
        this.orthoBut = new TextButton(75, 111, 75, 18, n, n2, "Orthographic", this.captionfont);
        this.equiBut.select();
        this.linearBut = new TextButton(this.smX + 75, this.smY, 70, 18, n, n2, "Linear Scale", this.captionfont);
        this.logBut = new TextButton(this.smX, this.smY, 70, 18, n, n2, "Log Scale", this.captionfont);
        this.logBut.select();
        this.linearBut.deselect();
        this.RA = new RArrowButton(this.ohX + 112, this.ohY - this.ohH / 2 - 24, 16, 16, n, n);
        this.LA = new LArrowButton(this.ohX - 128, this.ohY - this.ohH / 2 - 24, 16, 16, n, n);
    }

    public void draw() {
        this.background(255);
        float f = PApplet.parseFloat((String)this.scalemax.getText());
        float f2 = PApplet.parseFloat((String)this.scalemin.getText());
        float f3 = PApplet.parseFloat((String)this.scaledecades.getText());
        if (this.fileload) {
            if (this.dataformat.equals("Andy/Klems Full Horizon")) {
                this.hemispherical = this.drawKlemsHorizionFill(this.ohX, this.ohY, this.ohW, this.incident, this.fronttrans, f2, f, f3, this.scaleLog);
            } else if (this.dataformat.equals("TensorTree4")) {
                this.hemispherical = this.drawTTFill_b(this.ohX, this.ohY, this.ohW, this.invec, this.outZ, this.fronttrans, f2, f, f3, this.scaleLog);
                this.projection = "orthographic";
                this.orthoBut.select();
                this.equiBut.deselect();
                this.fill(0);
                this.textFont(this.buttonfont);
                this.textAlign(37, 3);
                this.text("Theta: " + (float)((int)(10.0f * this.inangle[0])) / 10.0f, (float)this.ihX + 0.35f * (float)this.ihW, (float)this.ihY + 0.4f * (float)this.ihH);
                this.text("Phi: " + (float)((int)(10.0f * this.inangle[1])) / 10.0f, (float)this.ihX + 0.35f * (float)this.ihW, (float)this.ihY + 0.4f * (float)this.ihH + 20.0f);
            } else {
                this.hemispherical = this.drawKlemsFill(this.ohX, this.ohY, this.ohW, this.incident, this.fronttrans, f2, f, f3, this.scaleLog);
            }
            this.textAlign(3, 101);
            this.textFont(this.buttonfont, 16.0f);
            this.fill(0);
            this.text(String.valueOf(this.Wavelength) + " " + this.Direction, this.ohX, this.ohY - this.ohH / 2 - 32);
            this.text("Direct Hemispherical = " + BSDFViewer.nfc((float)(this.hemispherical * 100.0f), (int)1) + "%", this.ohX, this.ohY - this.ohH / 2 - 16);
            this.stroke(0);
            this.fill(175);
            if (this.curBRTDF > 1) {
                this.LA.display();
            }
            if (this.curBRTDF < this.numBRTDF) {
                this.RA.display();
            }
        }
        this.image(this.logo, 1000.0f, 630.0f, 170.0f, 60.0f);
        this.drawVerticalScale(this.sX, this.sY, 30, 500, f2, f, f3, this.scaleLog);
        this.stroke(0);
        this.fill(0);
        this.inputPanel.setLayout(new BorderLayout());
        this.add(this.inputPanel);
        this.inputPanel.setBounds(this.smX + 104, this.smY + 24, 40, 22);
        this.inputPanel.add(this.scalemax);
        this.scalemax.addActionListener(new MyActionListener());
        this.textAlign(37, 102);
        this.text("Scale Maximum:", this.smX + 3, this.smY + 45);
        this.decPanel.setLayout(new BorderLayout());
        this.add(this.decPanel);
        this.decPanel.setBackground(Color.white);
        this.decPanel.setBounds(this.smX + 114, this.smY + 48, 30, 22);
        if (this.scaleLog) {
            this.decPanel.remove(this.scalemin);
            this.decPanel.add(this.scaledecades);
            this.scaledecades.addActionListener(new MyActionListener());
            this.text("Number of Decades:", this.smX + 3, this.smY + 69);
        } else {
            this.decPanel.remove(this.scaledecades);
            this.add(this.decPanel);
            this.decPanel.add(this.scalemin);
            this.scalemin.addActionListener(new MyActionListener());
            this.text("Scale Minimum:                      %", this.smX + 3, this.smY + 69);
        }
        if (this.dataformat.equals("Andy/Klems Full Horizon")) {
            this.drawKlemsHorizionIncident(this.ihX, this.ihY, this.ihW, this.incident);
        } else if (this.dataformat.equals("TensorTree4")) {
            this.drawTTIncident(this.ihX, this.ihY, this.ihW, this.incidentx, this.incidenty);
        } else {
            this.drawKlemsIncident(this.ihX, this.ihY, this.ihW, this.incident);
        }
        this.textAlign(37, 3);
        this.stroke(0);
        this.loadBut.display();
        this.saveBut.display();
        this.helpBut.display();
        this.equiBut.display();
        this.orthoBut.display();
        this.patchBut.display();
        this.linearBut.display();
        this.logBut.display();
        this.fill(175);
        this.fill(0);
        this.textAlign(37, 3);
        this.textFont(this.captionfont);
        this.text(this.filename, 175.0f, 17.0f);
        this.textAlign(3, 101);
        this.textFont(this.buttonfont);
        this.text("Incident Hemisphere", this.ihX, this.ihY - this.ihH / 2 - 16);
        if (this.dataformat.equals("Andy/Klems Full Horizon")) {
            this.drawKlemsHorizion(this.ihX, this.ihY, this.ihW);
            this.drawKlemsHorizion(this.ohX, this.ohY, this.ohW);
            if (this.dispNumbers) {
                this.drawPatchNumbersHorizion(this.ihX, this.ihY, this.ihW, this.ihH, false);
                this.drawPatchNumbersHorizion(this.ohX, this.ohY, this.ohW, this.ohH, true);
            }
        } else if (!this.dataformat.equals("TensorTree4")) {
            this.drawKlems(this.ihX, this.ihY, this.ihW);
            this.drawKlems(this.ohX, this.ohY, this.ohW);
            if (this.dispNumbers) {
                this.drawPatchNumbers(this.ihX, this.ihY, this.ihW, this.ihH, false);
                this.drawPatchNumbers(this.ohX, this.ohY, this.ohW, this.ohH, true);
            }
        }
        if (this.patchval < 101.0f) {
            this.fill(255);
            this.textAlign(3, 102);
            this.textFont(this.buttonfont);
            this.text(String.valueOf(BSDFViewer.nfc((float)this.patchval, (int)2)) + "%", this.mouseX, this.mouseY);
        }
        if (this.showHelp) {
            this.Help();
        }
        if (this.loading == 1) {
            this.textFont(this.loadingfont);
            this.fill(255.0f, 255.0f, 255.0f);
            this.rect(this.ohX - 80, this.ohY - 27, 160.0f, 40.0f);
            this.fill(75.0f, 75.0f, 75.0f);
            this.text("Loading...", this.ohX, this.ohY - 20);
            BSDFViewer.println((String)"loading");
        }
        if (this.error) {
            this.showError(this.ErrMsg);
            this.error = false;
        }
    }

    public void mousePressed() {
        this.textFont(this.helpfont);
        if (this.loadBut.pressed()) {
            this.filename = this.getfile();
            if (!this.filename.equals("")) {
                this.loadBSDFfile(this.filename);
            }
        }
        if (this.saveBut.pressed()) {
            this.saveImage();
        }
        if (this.helpBut.pressed()) {
            boolean bl = this.showHelp = !this.showHelp;
        }
        if (this.patchBut.pressed()) {
            boolean bl = this.dispNumbers = !this.dispNumbers;
        }
        if (this.equiBut.pressed()) {
            this.projection = "equidistant";
            this.orthoBut.deselect();
            this.equiBut.select();
        }
        if (this.orthoBut.pressed()) {
            this.projection = "orthographic";
            this.orthoBut.select();
            this.equiBut.deselect();
        }
        if (this.linearBut.pressed()) {
            this.scaleLog = false;
            this.logBut.deselect();
            this.linearBut.select();
        }
        if (this.logBut.pressed()) {
            this.scaleLog = true;
            this.logBut.select();
            this.linearBut.deselect();
        }
        if (this.insideEllipse(this.mouseX, this.mouseY, this.ihX, this.ihY, this.ihW, this.ihH)) {
            if (this.dataformat.equals("Andy/Klems Full Horizon")) {
                this.incident = this.whichPatchHorizion(this.mouseX, this.mouseY, this.ihX, this.ihY, this.ihW, this.ihH);
            } else if (this.dataformat.equals("TensorTree4")) {
                this.invec = this.whichTTPatch(this.mouseX, this.mouseY, this.inZ, this.ihX, this.ihY, this.ihW, this.ihH);
                this.incidentx = this.mouseX;
                this.incidenty = this.mouseY;
                this.inangle[0] = BSDFViewer.acos((float)((float)this.invec[2])) * 180.0f / (float)Math.PI;
                this.inangle[1] = BSDFViewer.atan2((float)((float)this.invec[1]), (float)(-((float)this.invec[0]))) * 180.0f / (float)Math.PI;
            } else {
                this.incident = this.whichPatch(this.mouseX, this.mouseY, this.ihX, this.ihY, this.ihW, this.ihH);
            }
        }
        if (this.curBRTDF > 1 && this.fileload && this.LA.pressed()) {
            --this.curBRTDF;
            if (this.dataformat.equals("LBNL/Klems Full")) {
                this.loadBSDFfile(this.filename);
            } else {
                if (this.curBRTDF == 1) {
                    this.Direction = "Visible Front Transmission";
                    this.inZ = 1;
                    this.outZ = -1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 2) {
                    this.Direction = "Visible Front Reflection";
                    this.inZ = 1;
                    this.outZ = 1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 3) {
                    this.Direction = "Visible Back Transmission";
                    this.inZ = -1;
                    this.outZ = 1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 4) {
                    this.Direction = "Visible Back Reflection";
                    this.inZ = -1;
                    this.outZ = -1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
            }
        }
        if (this.curBRTDF < this.numBRTDF && this.fileload && this.RA.pressed()) {
            ++this.curBRTDF;
            if (this.dataformat.equals("LBNL/Klems Full")) {
                this.loadBSDFfile(this.filename);
            } else {
                if (this.curBRTDF == 1) {
                    this.Direction = "Visible Front Transmission";
                    this.inZ = 1;
                    this.outZ = -1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 2) {
                    this.Direction = "Visible Front Reflection";
                    this.inZ = 1;
                    this.outZ = 1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 3) {
                    this.Direction = "Visible Back Transmission";
                    this.inZ = -1;
                    this.outZ = 1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 4) {
                    this.Direction = "Visible Back Reflection";
                    this.inZ = -1;
                    this.outZ = -1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
            }
        }
        if (this.fileload && this.insideEllipse(this.mouseX, this.mouseY, this.ohX, this.ohY, this.ohW, this.ohH)) {
            if (this.dataformat.equals("Andy/Klems Full Horizon")) {
                this.overpatch = this.whichPatchTransHorizion(this.mouseX, this.mouseY, this.ohX, this.ohY, this.ohW, this.ohH);
                this.patchval = 100.0f * this.fluxpercent(this.incident, this.overpatch, PApplet.parseFloat((String)this.fronttrans[(this.overpatch - 1) * this.ndivs + this.incident - 1]));
            } else if (this.dataformat.equals("TensorTree4")) {
                this.patchval = 1000.0f;
            } else {
                this.overpatch = this.whichPatchTrans(this.mouseX, this.mouseY, this.ohX, this.ohY, this.ohW, this.ohH);
                this.patchval = 100.0f * this.fluxpercent(this.incident, this.overpatch, PApplet.parseFloat((String)this.fronttrans[(this.overpatch - 1) * this.ndivs + this.incident - 1]));
            }
            this.textAlign(3, 102);
            this.textFont(this.buttonfont, 16.0f);
            this.fill(0);
            this.stroke(0);
        } else {
            this.patchval = 1000.0f;
        }
        this.loading = 0;
        this.redraw();
    }

    public void keyPressed() {
        if (this.key == '\r' || this.key == '\n') {
            this.redraw();
        }
    }

    public String getfile() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFileChooser jFileChooser = new JFileChooser(this.filename);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(new String(".xml"), "xml");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        this.loading = 1;
        this.redraw();
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.filename = file.getPath();
            return this.filename;
        }
        BSDFViewer.println((String)"Open command cancelled by user.");
        return "";
    }

    public void saveImage() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFileChooser jFileChooser = new JFileChooser(this.savefile);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(new String(".png"), "png");
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter(new String(".tif"), "tif");
        FileNameExtensionFilter fileNameExtensionFilter3 = new FileNameExtensionFilter(new String(".jpg"), "jpg");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(fileNameExtensionFilter3);
        jFileChooser.setFileFilter(fileNameExtensionFilter2);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            int n2 = PApplet.parseInt((float)file.getPath().length());
            this.savefile = file.getPath().substring(n2 - 4, n2).equals(jFileChooser.getFileFilter().getDescription()) ? file.getPath() : String.valueOf(file.getPath()) + jFileChooser.getFileFilter().getDescription();
            this.save(this.savefile);
        } else {
            BSDFViewer.println((String)"Open command cancelled by user.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadBSDFfile(String string) {
        try {
            this.xml = new XMLElement((PApplet)this, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.dataformat = this.xml.getChild("Optical").getChild("Layer").getChild("DataDefinition").getChild("IncidentDataStructure").getContent();
        if (this.dataformat.equals("Columns")) {
            this.dataformat = this.xml.getChild("Optical").getChild("Layer").getChild("DataDefinition").getChild("AngleBasis").getChild("AngleBasisName").getContent();
            if (this.dataformat.equals("LBNL/Klems Full")) {
                this.ndivs = 145;
                libBSDF.Free();
                this.fileload = true;
                this.numBRTDF = 0;
                String[] stringArray = this.xml.getChild("Optical").getChild("Layer").listChildren();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals("WavelengthData")) {
                        ++this.numBRTDF;
                    }
                    ++n;
                }
                if (this.curBRTDF > this.numBRTDF) {
                    this.curBRTDF = this.numBRTDF;
                }
                XMLElement xMLElement = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("WavelengthDataBlock").getChild("ScatteringData");
                XMLElement xMLElement2 = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("Wavelength");
                this.Wavelength = xMLElement2.getContent();
                XMLElement xMLElement3 = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("WavelengthDataBlock").getChild("WavelengthDataDirection");
                this.Direction = xMLElement3.getContent();
                this.fronttrans = BSDFViewer.splitTokens((String)xMLElement.getContent(), (String)", \n\t");
                return;
            } else {
                if (!this.dataformat.equals("Andy/Klems Full Horizon")) return;
                this.ndivs = 146;
                libBSDF.Free();
                this.fileload = true;
                this.numBRTDF = 0;
                String[] stringArray = this.xml.getChild("Optical").getChild("Layer").listChildren();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals("WavelengthData")) {
                        ++this.numBRTDF;
                    }
                    ++n;
                }
                if (this.curBRTDF > this.numBRTDF) {
                    this.curBRTDF = this.numBRTDF;
                }
                XMLElement xMLElement = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("WavelengthDataBlock").getChild("ScatteringData");
                XMLElement xMLElement4 = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("Wavelength");
                this.Wavelength = xMLElement4.getContent();
                XMLElement xMLElement5 = this.xml.getChild("Optical").getChild("Layer").getChild(this.curBRTDF + stringArray.length - this.numBRTDF - 1).getChild("WavelengthDataBlock").getChild("WavelengthDataDirection");
                this.Direction = xMLElement5.getContent();
                this.fronttrans = BSDFViewer.splitTokens((String)xMLElement.getContent(), (String)", \n\t");
            }
            return;
        } else {
            if (this.dataformat.equals("TensorTree4")) {
                this.fileload = true;
                this.numBRTDF = 4;
                if (this.curBRTDF == 1) {
                    this.Direction = "Visible Front Transmission";
                    this.inZ = 1;
                    this.outZ = -1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 2) {
                    this.Direction = "Visible Front Reflection";
                    this.inZ = 1;
                    this.outZ = 1;
                    if (this.invec[2] < 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 3) {
                    this.Direction = "Visible Back Transmission";
                    this.inZ = -1;
                    this.outZ = 1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                if (this.curBRTDF == 4) {
                    this.Direction = "Visible Back Reflection";
                    this.inZ = -1;
                    this.outZ = -1;
                    if (this.invec[2] > 0.0) {
                        this.invec[2] = -this.invec[2];
                    }
                }
                BSDFViewer.println((String)("in: " + this.invec[2]));
                libBSDF.Free();
                return;
            }
            string = "The BSDF must have LBNL/Klems Full angle basis (tensor tree BSDF's are not supported)";
            this.fileload = false;
            this.error = true;
            this.ErrMsg = "Unrecognized BSDF angle basis: " + this.dataformat;
            this.dataformat = "LBNL/Klems Full";
            return;
        }
    }

    public boolean insideEllipse(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - n3;
        int n8 = n2 - n4;
        return BSDFViewer.sq((float)n7) / BSDFViewer.sq((float)(n5 / 2)) + BSDFViewer.sq((float)n8) / BSDFViewer.sq((float)(n6 / 2)) < 1.0f;
    }

    public float fluxpercent(int n, int n2, float f) {
        float[] fArray = new float[]{0.9981f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f};
        float[] fArray2 = new float[]{0.023909f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f};
        float[] fArray3 = new float[]{1.0f, 0.9981f, 0.9981f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.98106f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.93612f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.86273f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.76313f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.64034f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.4981f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.34072f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f, 0.12941f};
        float[] fArray4 = new float[]{0.011955f, 0.011955f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023773f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.023412f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.027381f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.029333f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.034958f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.039521f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.064324f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f, 0.135517f};
        float f2 = this.dataformat.equals("Andy/Klems Full Horizon") ? f * fArray4[n2 - 1] * fArray3[n2 - 1] : (this.dataformat.equals("TensorTree4") ? 1000.0f : f * fArray2[n2 - 1] * fArray[n2 - 1]);
        return f2;
    }

    public float drawKlemsFill(int n, int n2, int n3, int n4, String[] stringArray, float f, float f2, float f3, boolean bl) {
        this.colorMode(3, 1.5f);
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        float f4 = 0.0f;
        int n5 = 145;
        this.noStroke();
        int n6 = 8;
        while (n6 >= 0) {
            float f5 = (float)Math.PI * 2 / (float)nArray3[n6];
            int n7 = 0;
            while (n7 < nArray3[n6]) {
                float f6 = this.fluxpercent(n4, n5, PApplet.parseFloat((String)this.fronttrans[(n5 - 1) * this.ndivs + n4 - 1]));
                if (f6 > f2 / 100.0f) {
                    this.fill(0.0f, 1.25f, 1.25f);
                } else if (bl) {
                    if (f6 / f2 * 100.0f - BSDFViewer.pow((float)10.0f, (float)(-f3)) < 0.0f) {
                        this.fill(1.0f, 1.25f, 1.25f);
                    } else {
                        this.fill(0.0f - BSDFViewer.log((float)(100.0f * f6 / f2)) / BSDFViewer.log((float)10.0f) / f3, 1.25f, 1.25f);
                    }
                } else if (f6 < f) {
                    this.fill(1.0f, 1.25f, 1.25f);
                } else {
                    this.fill(1.0f - (f6 - f / 100.0f) * 100.0f / (f2 - f), 1.25f, 1.25f);
                }
                float f7 = (float)Math.PI - f5 * (float)(n7 + 1) - f5 / 2.0f;
                float f8 = (float)Math.PI - f5 * (float)n7 - f5 / 2.0f;
                if (this.projection == "orthographic") {
                    this.arc(n, n2, BSDFViewer.sin((float)((float)nArray2[n6 + 1] * (float)Math.PI / 180.0f)) * (float)n3, BSDFViewer.sin((float)((float)nArray2[n6 + 1] * (float)Math.PI / 180.0f)) * (float)n3, f7, f8);
                } else if (this.projection == "equidistant") {
                    this.arc(n, n2, (float)nArray2[n6 + 1] / 90.0f * (float)n3, (float)nArray2[n6 + 1] / 90.0f * (float)n3, f7, f8);
                }
                f4 += this.fluxpercent(n4, n5, PApplet.parseFloat((String)stringArray[(n5 - 1) * 145 + n4 - 1]));
                --n5;
                ++n7;
            }
            --n6;
        }
        this.colorMode(1, 255.0f);
        return f4;
    }

    public void drawKlemsIncident(int n, int n2, int n3, int n4) {
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        int n5 = 145;
        this.noStroke();
        int n6 = 8;
        while (n6 >= 0) {
            float f = (float)Math.PI * 2 / (float)nArray3[n6];
            int n7 = 0;
            while (n7 <= nArray3[n6] - 1) {
                this.fill(235);
                if (n5 == n4) {
                    this.fill(255.0f, 255.0f, 0.0f);
                }
                float f2 = -f * (float)(n7 + 1) - f / 2.0f;
                float f3 = -f * (float)n7 - f / 2.0f;
                if (this.projection == "orthographic") {
                    this.arc(n, n2, BSDFViewer.sin((float)((float)nArray2[n6 + 1] * (float)Math.PI / 180.0f)) * (float)n3, BSDFViewer.sin((float)((float)nArray2[n6 + 1] * (float)Math.PI / 180.0f)) * (float)n3, f2, f3);
                } else if (this.projection == "equidistant") {
                    this.arc(n, n2, (float)nArray2[n6 + 1] / 90.0f * (float)n3, (float)nArray2[n6 + 1] / 90.0f * (float)n3, f2, f3);
                }
                --n5;
                ++n7;
            }
            --n6;
        }
    }

    public void drawKlems(int n, int n2, int n3) {
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.noFill();
        this.ellipseMode(3);
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        int n4 = 1;
        while (n4 < nArray2.length) {
            if (this.projection == "orthographic") {
                this.ellipse(n, n2, BSDFViewer.sin((float)((float)nArray2[n4] * (float)Math.PI / 180.0f)) * (float)n3, BSDFViewer.sin((float)((float)nArray2[n4] * (float)Math.PI / 180.0f)) * (float)n3);
            } else if (this.projection == "equidistant") {
                this.ellipse(n, n2, (float)nArray2[n4] / 90.0f * (float)n3, (float)nArray2[n4] / 90.0f * (float)n3);
            }
            ++n4;
        }
        n4 = 1;
        while (n4 < nArray2.length - 1) {
            float f = (float)Math.PI * 2 / (float)nArray3[n4];
            int n5 = 0;
            while (n5 < nArray3[n4]) {
                float f2;
                float f3;
                float f4;
                float f5;
                float f6 = f * (float)(n5 - 1) + f / 2.0f;
                if (this.projection == "orthographic") {
                    f5 = (float)n + BSDFViewer.sin((float)((float)nArray2[n4] * (float)Math.PI / 180.0f)) * (float)n3 / 2.0f * BSDFViewer.cos((float)f6);
                    f4 = (float)n + BSDFViewer.sin((float)((float)nArray2[n4 + 1] * (float)Math.PI / 180.0f)) * (float)n3 / 2.0f * BSDFViewer.cos((float)f6);
                    f3 = (float)n2 + BSDFViewer.sin((float)((float)nArray2[n4] * (float)Math.PI / 180.0f)) * (float)n3 / 2.0f * BSDFViewer.sin((float)f6);
                    f2 = (float)n2 + BSDFViewer.sin((float)((float)nArray2[n4 + 1] * (float)Math.PI / 180.0f)) * (float)n3 / 2.0f * BSDFViewer.sin((float)f6);
                    this.line(f5, f3, f4, f2);
                } else if (this.projection == "equidistant") {
                    f5 = (float)n + (float)nArray2[n4] / 90.0f * (float)n3 / 2.0f * BSDFViewer.cos((float)f6);
                    f4 = (float)n + (float)nArray2[n4 + 1] / 90.0f * (float)n3 / 2.0f * BSDFViewer.cos((float)f6);
                    f3 = (float)n2 + (float)nArray2[n4] / 90.0f * (float)n3 / 2.0f * BSDFViewer.sin((float)f6);
                    f2 = (float)n2 + (float)nArray2[n4 + 1] / 90.0f * (float)n3 / 2.0f * BSDFViewer.sin((float)f6);
                    this.line(f5, f3, f4, f2);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void drawPatchNumbers(int n, int n2, int n3, int n4, boolean bl) {
        float f = 0.0f;
        if (bl) {
            f = (float)Math.PI;
        }
        this.fill(0);
        this.textFont(this.captionfont);
        this.textAlign(3, 3);
        int n5 = 1;
        float[] fArray = new float[]{0.0f, 10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 82.5f};
        int[] nArray = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        int n6 = 0;
        while (n6 < fArray.length) {
            float f2 = fArray[n6] / 90.0f * (float)n3 / 2.0f;
            float f3 = (float)Math.PI * 2 / (float)nArray[n6];
            if (this.projection == "orthographic") {
                f2 = BSDFViewer.sin((float)(fArray[n6] * (float)Math.PI / 180.0f)) * (float)n3 / 2.0f;
                if (n6 == fArray.length - 2) {
                    f -= 0.043633234f;
                }
                if (n6 == fArray.length - 1) {
                    f += 0.043633234f;
                }
            }
            int n7 = 0;
            while (n7 < nArray[n6]) {
                float f4 = BSDFViewer.cos((float)(f3 * (float)n7 + f)) * f2 + (float)n;
                float f5 = BSDFViewer.sin((float)(f3 * (float)n7 + f)) * f2 + (float)n2;
                this.text(BSDFViewer.nfc((float)n5, (int)0), f4, f5);
                ++n5;
                ++n7;
            }
            ++n6;
        }
    }

    public int whichPatch(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n - n3;
        int n10 = n2 - n4;
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        float f = BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6)))) * 90.0f;
        if (this.projection == "orthographic") {
            f = BSDFViewer.asin((float)BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6))))) * 180.0f / (float)Math.PI;
        }
        int n11 = 1;
        while (n11 <= 10) {
            if (f < (float)nArray2[n11]) {
                n8 = n11 - 1;
                break;
            }
            n7 += nArray3[n11 - 1];
            ++n11;
        }
        float f2 = (float)Math.PI * 2 / (float)nArray3[n8];
        float f3 = f2 / 2.0f + BSDFViewer.atan2((float)n10, (float)n9);
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        int n12 = BSDFViewer.floor((float)(f3 / f2 + 1.0f));
        BSDFViewer.println((int)(n12 + n7));
        return n12 + n7;
    }

    public int whichPatchTrans(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n - n3;
        int n10 = n2 - n4;
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        float f = BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6)))) * 90.0f;
        if (this.projection == "orthographic") {
            f = BSDFViewer.asin((float)BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6))))) * 180.0f / (float)Math.PI;
        }
        int n11 = 1;
        while (n11 <= 10) {
            if (f < (float)nArray2[n11]) {
                n8 = n11 - 1;
                break;
            }
            n7 += nArray3[n11 - 1];
            ++n11;
        }
        float f2 = (float)Math.PI * 2 / (float)nArray3[n8];
        float f3 = f2 / 2.0f + BSDFViewer.atan2((float)(-n10), (float)(-n9));
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        int n12 = BSDFViewer.floor((float)(f3 / f2 + 1.0f));
        return n12 + n7;
    }

    public float drawKlemsHorizionFill(int n, int n2, int n3, int n4, String[] stringArray, float f, float f2, float f3, boolean bl) {
        this.colorMode(3, 1.5f);
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        float f4 = 0.0f;
        int n5 = 146;
        this.noStroke();
        int n6 = 8;
        while (n6 >= 0) {
            float f5 = (float)Math.PI * 2 / (float)nArray3[n6];
            int n7 = 0;
            while (n7 < nArray3[n6]) {
                float f6 = this.fluxpercent(n4, n5, PApplet.parseFloat((String)stringArray[(n5 - 1) * 146 + n4 - 1]));
                if (f6 > f2 / 100.0f) {
                    this.fill(0.0f, 1.25f, 1.25f);
                } else if (bl) {
                    if (f6 / f2 * 100.0f - BSDFViewer.pow((float)10.0f, (float)(-f3)) < 0.0f) {
                        this.fill(1.0f, 1.25f, 1.25f);
                    } else {
                        this.fill(0.0f - BSDFViewer.log((float)(100.0f * f6 / f2)) / BSDFViewer.log((float)10.0f) / f3, 1.25f, 1.25f);
                    }
                } else if (f6 < f) {
                    this.fill(1.0f, 1.25f, 1.25f);
                } else {
                    this.fill(1.0f - (f6 - f / 100.0f) * 100.0f / (f2 - f), 1.25f, 1.25f);
                }
                float f7 = f5 * (float)n7;
                float f8 = f5 * (float)(n7 + 1);
                this.arc(n, n2, (float)nArray2[n6 + 1] / 90.0f * (float)n3, (float)nArray2[n6 + 1] / 90.0f * (float)n3, f7, f8);
                f4 += f6;
                --n5;
                ++n7;
            }
            --n6;
        }
        this.colorMode(1, 255.0f);
        return f4;
    }

    public void drawKlemsHorizionIncident(int n, int n2, int n3, int n4) {
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        int n5 = 146;
        this.noStroke();
        int n6 = 8;
        while (n6 >= 0) {
            float f = (float)Math.PI * 2 / (float)nArray3[n6];
            int n7 = 0;
            while (n7 <= nArray3[n6] - 1) {
                this.fill(235);
                if (n5 == n4) {
                    this.fill(255.0f, 255.0f, 0.0f);
                }
                float f2 = (float)Math.PI + f * (float)n7;
                float f3 = (float)Math.PI + f * (float)(n7 + 1);
                this.arc(n, n2, (float)nArray2[n6 + 1] / 90.0f * (float)n3, (float)nArray2[n6 + 1] / 90.0f * (float)n3, f2, f3);
                --n5;
                ++n7;
            }
            --n6;
        }
    }

    public void drawKlemsHorizion(int n, int n2, int n3) {
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.noFill();
        this.ellipseMode(3);
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        int n4 = 1;
        while (n4 < nArray2.length) {
            this.ellipse(n, n2, (float)nArray2[n4] / 90.0f * (float)n3, (float)nArray2[n4] / 90.0f * (float)n3);
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray2.length - 1) {
            float f = (float)Math.PI * 2 / (float)nArray3[n4];
            int n5 = 0;
            while (n5 < nArray3[n4]) {
                float f2 = f * (float)(n5 - 1);
                float f3 = (float)n + (float)nArray2[n4] / 90.0f * (float)n3 / 2.0f * BSDFViewer.cos((float)f2);
                float f4 = (float)n + (float)nArray2[n4 + 1] / 90.0f * (float)n3 / 2.0f * BSDFViewer.cos((float)f2);
                float f5 = (float)n2 + (float)nArray2[n4] / 90.0f * (float)n3 / 2.0f * BSDFViewer.sin((float)f2);
                float f6 = (float)n2 + (float)nArray2[n4 + 1] / 90.0f * (float)n3 / 2.0f * BSDFViewer.sin((float)f2);
                this.line(f3, f5, f4, f6);
                ++n5;
            }
            ++n4;
        }
    }

    public void drawPatchNumbersHorizion(int n, int n2, int n3, int n4, boolean bl) {
        float f = (float)Math.PI;
        if (bl) {
            f = 0.0f;
        }
        this.fill(0);
        this.textFont(this.captionfont);
        this.textAlign(3, 3);
        int n5 = 1;
        float[] fArray = new float[]{2.0f, 10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 82.5f};
        int[] nArray = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        int n6 = 0;
        while (n6 < fArray.length) {
            float f2 = fArray[n6] / 90.0f * (float)n3 / 2.0f;
            float f3 = (float)Math.PI * -2 / (float)nArray[n6];
            int n7 = 0;
            while (n7 < nArray[n6]) {
                float f4 = BSDFViewer.cos((float)(f3 * (float)n7 + f3 / 2.0f + f)) * f2 + (float)n;
                float f5 = BSDFViewer.sin((float)(f3 * (float)n7 + f3 / 2.0f + f)) * f2 + (float)n2;
                this.text(BSDFViewer.nfc((float)n5, (int)0), f4, f5);
                ++n5;
                ++n7;
            }
            ++n6;
        }
    }

    public int whichPatchHorizion(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n - n3;
        int n10 = n2 - n4;
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        float f = BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6)))) * 90.0f;
        int n11 = 1;
        while (n11 <= 10) {
            if (f < (float)nArray2[n11]) {
                n8 = n11 - 1;
                break;
            }
            n7 += nArray3[n11 - 1];
            ++n11;
        }
        float f2 = (float)Math.PI * 2 / (float)nArray3[n8];
        float f3 = BSDFViewer.atan2((float)n10, (float)(-n9));
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        int n12 = BSDFViewer.floor((float)(f3 / f2 + 1.0f));
        BSDFViewer.println((int)(n12 + n7));
        return n12 + n7;
    }

    public int whichPatchTransHorizion(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n - n3;
        int n10 = n2 - n4;
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{2, 8, 16, 20, 24, 24, 24, 16, 12};
        float f = BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6)))) * 90.0f;
        int n11 = 1;
        while (n11 <= 10) {
            if (f < (float)nArray2[n11]) {
                n8 = n11 - 1;
                break;
            }
            n7 += nArray3[n11 - 1];
            ++n11;
        }
        float f2 = (float)Math.PI * 2 / (float)nArray3[n8];
        float f3 = BSDFViewer.atan2((float)(-n10), (float)n9);
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        int n12 = BSDFViewer.floor((float)(f3 / f2 + 1.0f));
        BSDFViewer.println((int)(n12 + n7));
        return n12 + n7;
    }

    public void drawTTIncident(int n, int n2, int n3, int n4, int n5) {
        this.fill(235);
        this.ellipse(n, n2, n3, n3);
        this.noFill();
        this.drawTT(n, n2, n3);
        this.fill(255.0f, 0.0f, 0.0f);
        this.line(n4 - 6, n5 - 6, n4 + 6, n5 + 6);
        this.line(n4 + 6, n5 - 6, n4 - 6, n5 + 6);
        this.ellipse(n4, n5, 4.0f, 4.0f);
    }

    public void drawTT(int n, int n2, int n3) {
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        float[] fArray4 = new float[2];
        float[] fArray5 = new float[2];
        this.noFill();
        float f = 0.03125f;
        float f2 = -1.0f;
        while (f2 < 1.0f) {
            float f3 = -1.0f;
            while (f3 < 1.0f) {
                fArray = this.ab2sc(f2, f3);
                fArray2 = this.ab2sc(f2, f3 + f / 2.0f);
                fArray3 = this.ab2sc(f2, f3 + f);
                fArray4 = this.ab2sc(f2 + f / 2.0f, f3);
                fArray5 = this.ab2sc(f2 + f, f3);
                if (f2 >= f3 && f2 >= -f3 || -f2 > f3 && -f2 > -f3) {
                    if (f3 % 0.125f == 0.0f) {
                        this.stroke(0);
                    } else if (f3 % 0.0625f == 0.0f) {
                        this.stroke(0, 120.0f);
                    } else {
                        this.stroke(0, 30.0f);
                    }
                    this.line((float)n + fArray[0] * (float)n3 / 2.0f, (float)n2 + fArray[1] * (float)n3 / 2.0f, (float)n + fArray4[0] * (float)n3 / 2.0f, (float)n2 + fArray4[1] * (float)n3 / 2.0f);
                    this.line((float)n + fArray4[0] * (float)n3 / 2.0f, (float)n2 + fArray4[1] * (float)n3 / 2.0f, (float)n + fArray5[0] * (float)n3 / 2.0f, (float)n2 + fArray5[1] * (float)n3 / 2.0f);
                }
                if (f3 >= f2 && f3 >= -f2 || -f3 > f2 && -f3 > -f2) {
                    if (f2 % 0.125f == 0.0f) {
                        this.stroke(0);
                    } else if (f2 % 0.0625f == 0.0f) {
                        this.stroke(0, 120.0f);
                    } else {
                        this.stroke(0, 30.0f);
                    }
                    this.line((float)n + fArray[0] * (float)n3 / 2.0f, (float)n2 + fArray[1] * (float)n3 / 2.0f, (float)n + fArray2[0] * (float)n3 / 2.0f, (float)n2 + fArray2[1] * (float)n3 / 2.0f);
                    this.line((float)n + fArray2[0] * (float)n3 / 2.0f, (float)n2 + fArray2[1] * (float)n3 / 2.0f, (float)n + fArray3[0] * (float)n3 / 2.0f, (float)n2 + fArray3[1] * (float)n3 / 2.0f);
                }
                f3 += f;
            }
            f2 += f;
        }
        f2 = 1.0f;
        while (f2 > 0.0f) {
            if (f2 % 0.125f == 0.0f) {
                this.stroke(0);
            } else if (f2 % 0.0625f == 0.0f) {
                this.stroke(0, 120.0f);
            } else {
                this.stroke(0, 30.0f);
            }
            this.ellipse(n, n2, (float)n3 * f2, (float)n3 * f2);
            f2 -= f;
        }
        this.stroke(0);
    }

    public double[] whichTTPatch(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 / 2;
        int n9 = n4 - n;
        int n10 = n5 - n2;
        float f = 1.0f * (float)n9 / (float)n8;
        float f2 = 1.0f * (float)n10 / (float)n8;
        double d = (float)n3 * BSDFViewer.sqrt((float)(1.0f - f * f - f2 * f2));
        double[] dArray = new double[]{f, f2, d};
        return dArray;
    }

    public int whichPatchTransTT(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n - n3;
        int n10 = n2 - n4;
        int[] nArray = new int[10];
        nArray[1] = 5;
        nArray[2] = 15;
        nArray[3] = 25;
        nArray[4] = 35;
        nArray[5] = 45;
        nArray[6] = 55;
        nArray[7] = 65;
        nArray[8] = 75;
        nArray[9] = 90;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{1, 8, 16, 20, 24, 24, 24, 16, 12};
        float f = BSDFViewer.sqrt((float)(BSDFViewer.sq((float)(2.0f * (float)n9 / (float)n5)) + BSDFViewer.sq((float)(2.0f * (float)n10 / (float)n6)))) * 90.0f;
        int n11 = 1;
        while (n11 <= 10) {
            if (f < (float)nArray2[n11]) {
                n8 = n11 - 1;
                break;
            }
            n7 += nArray3[n11 - 1];
            ++n11;
        }
        float f2 = (float)Math.PI * 2 / (float)nArray3[n8];
        float f3 = f2 / 2.0f + BSDFViewer.atan2((float)(-n10), (float)n9);
        if (f3 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        int n12 = BSDFViewer.floor((float)(f3 / f2 + 1.0f));
        return n12 + n7;
    }

    public float[] ab2sc(float f, float f2) {
        float[] fArray = new float[2];
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (f >= f2 && f > -f2) {
            f3 = f;
            f4 = 0.7853982f * f2 / f;
        } else if (f2 > f && f2 >= -f) {
            f3 = f2;
            f4 = 0.7853982f * (2.0f - f / f2);
        } else if (-f > f2 && -f >= -f2) {
            f3 = -f;
            f4 = 0.7853982f * (4.0f + f2 / f);
        } else if (-f2 > -f && -f2 >= f) {
            f3 = -f2;
            f4 = 0.7853982f * (6.0f - f / f2);
        }
        fArray[0] = f3 * BSDFViewer.cos((float)f4);
        fArray[1] = f3 * BSDFViewer.sin((float)f4);
        return fArray;
    }

    public double[] ab2tp(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double[] dArray2 = new double[2];
        double d3 = 0.0;
        double d4 = 0.0;
        if (d >= d2 && d > -d2) {
            d3 = d;
            d4 = 0.7853981852531433 * d2 / d;
        } else if (d2 > d && d2 >= -d) {
            d3 = d2;
            d4 = 0.7853981852531433 * (2.0 - d / d2);
        } else if (-d > d2 && -d >= -d2) {
            d3 = -d;
            d4 = 0.7853981852531433 * (4.0 + d2 / d);
        } else if (-d2 > -d && -d2 >= d) {
            d3 = -d2;
            d4 = 0.7853981852531433 * (6.0 - d / d2);
        }
        dArray2[0] = Math.asin(d3);
        dArray2[1] = d4;
        return dArray2;
    }

    public float[] tp2sc(float[] fArray) {
        float[] fArray2 = new float[]{fArray[0], fArray[1]};
        return fArray2;
    }

    public float drawTTFill_b(int n, int n2, int n3, double[] dArray, int n4, String[] stringArray, float f, float f2, float f3, boolean bl) {
        this.colorMode(3, 1.5f);
        this.stroke(0);
        int n5 = 64;
        int n6 = 4096;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.25;
        double d4 = 1.25;
        double[] dArray2 = new double[4096];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double d5 = 0.0;
        double[] dArray5 = new double[2];
        float[] fArray = new float[2];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[260];
        double[] dArray8 = new double[260];
        this.myBSDFaddress = libBSDF.Load(this.filename);
        BSDFViewer.println((String)("\nin:   " + dArray[0] + "  " + dArray[1] + " " + dArray[2]));
        int n7 = 0;
        while (n7 < n6) {
            dArray5 = this.hv2ab(n7, n5);
            dArray3 = this.ab2tp(dArray5);
            double d6 = -Math.cos(dArray3[1]) * Math.sin(dArray3[0]);
            double d7 = Math.sin(dArray3[1]) * Math.sin(dArray3[0]);
            double d8 = (double)n4 * Math.sqrt(1.0 - d6 * d6 - d7 * d7);
            double[] dArray9 = new double[]{d6, d7, d8};
            dArray2[n7] = libBSDF.getBSDFvalue(dArray, dArray9, this.myBSDFaddress);
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            boolean bl2;
            double d9;
            double d10;
            int n8 = 2;
            dArray5 = this.hv2ab(n7, n5);
            dArray3 = this.ab2tp(dArray5);
            double d11 = d10 = dArray5[0];
            double d12 = d9 = dArray5[1];
            if (n7 % 4096 == 0) {
                bl2 = false;
                int n9 = 0;
                while (n9 < 4096) {
                    if (dArray2[n7] != dArray2[n7 + n9]) {
                        bl2 = true;
                    }
                    ++n9;
                }
                if (!bl2) {
                    n8 = 65;
                    dArray6 = this.hv2ab(n7 + 2730, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 4095;
                }
            }
            if (n7 % 1024 == 0) {
                bl2 = false;
                int n10 = 0;
                while (n10 < 1024) {
                    if (dArray2[n7] != dArray2[n7 + n10]) {
                        bl2 = true;
                    }
                    ++n10;
                }
                if (!bl2) {
                    n8 = 33;
                    dArray6 = this.hv2ab(n7 + 682, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 1023;
                }
            }
            if (n7 % 256 == 0) {
                bl2 = false;
                int n11 = 0;
                while (n11 < 256) {
                    if (dArray2[n7] != dArray2[n7 + n11]) {
                        bl2 = true;
                    }
                    ++n11;
                }
                if (!bl2) {
                    n8 = 17;
                    dArray6 = this.hv2ab(n7 + 170, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 255;
                }
            }
            if (n7 % 64 == 0) {
                bl2 = false;
                int n12 = 0;
                while (n12 < 64) {
                    if (dArray2[n7] != dArray2[n7 + n12]) {
                        bl2 = true;
                    }
                    ++n12;
                }
                if (!bl2) {
                    n8 = 9;
                    dArray6 = this.hv2ab(n7 + 42, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 63;
                }
            }
            if (n7 % 16 == 0) {
                bl2 = false;
                int n13 = 0;
                while (n13 < 16) {
                    if (dArray2[n7] != dArray2[n7 + n13]) {
                        bl2 = true;
                    }
                    ++n13;
                }
                if (!bl2) {
                    n8 = 5;
                    dArray6 = this.hv2ab(n7 + 10, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 15;
                }
            }
            if (n7 % 4 == 0) {
                bl2 = false;
                int n14 = 0;
                while (n14 < 4) {
                    if (dArray2[n7] != dArray2[n7 + n14]) {
                        bl2 = true;
                    }
                    ++n14;
                }
                if (!bl2) {
                    n8 = 3;
                    dArray6 = this.hv2ab(n7 + 2, n5);
                    if (dArray5[0] < dArray6[0]) {
                        d11 = dArray5[0];
                        d10 = dArray6[0];
                    } else {
                        d11 = dArray6[0];
                        d10 = dArray5[0];
                    }
                    if (dArray5[1] < dArray6[1]) {
                        d12 = dArray5[1];
                        d9 = dArray6[1];
                    } else {
                        d12 = dArray6[1];
                        d9 = dArray5[1];
                    }
                    n7 += 3;
                }
            }
            d2 = dArray2[n7] > (double)f2 ? 0.0 : (bl ? (dArray2[n7] / (double)f2 - (double)BSDFViewer.pow((float)10.0f, (float)(-f3)) < 0.0 ? 1.0 : 0.0 - Math.log(dArray2[n7] / (double)f2) / Math.log(10.0) / (double)f3) : (dArray2[n7] < (double)f ? 1.0 : 1.0 - (dArray2[n7] - (double)f) / (double)(f2 - f)));
            this.fill((float)d2, (float)d3, (float)d4);
            int n15 = 0;
            while (n15 < n8) {
                dArray7[n15] = d11 + (double)((float)n15 * 2.0f / (float)n5) - (double)(1.0f / (float)n5);
                dArray7[n15 + n8] = d10 + (double)(1.0f / (float)n5);
                dArray7[n15 + n8 * 2] = d10 - (double)((float)n15 * 2.0f / (float)n5) + (double)(1.0f / (float)n5);
                dArray7[n15 + n8 * 3] = d11 - (double)(1.0f / (float)n5);
                dArray8[n15] = d12 - (double)(1.0f / (float)n5);
                dArray8[n15 + n8 * 1] = d12 + (double)((float)n15 * 2.0f / (float)n5) - (double)(1.0f / (float)n5);
                dArray8[n15 + n8 * 2] = d9 + (double)(1.0f / (float)n5);
                dArray8[n15 + n8 * 3] = d9 - (double)((float)n15 * 2.0f / (float)n5) + (double)(1.0f / (float)n5);
                ++n15;
            }
            this.beginShape();
            int n16 = 0;
            while (n16 < n8 * 4) {
                fArray = this.ab2sc((float)dArray7[n16], (float)dArray8[n16]);
                float f4 = (float)n3 * fArray[0] / 2.0f + (float)n;
                float f5 = (float)n2 - (float)n3 * fArray[1] / 2.0f;
                this.vertex(f4, f5);
                ++n16;
            }
            this.endShape(2);
            dArray4 = this.ab2tp(dArray6);
            d5 = (Math.cos(dArray3[0]) + Math.cos(dArray4[0])) * 0.5;
            d5 = 1.0;
            d += (double)(7.669904E-4f * (float)(n8 - 1) * (float)(n8 - 1)) * d5 * dArray2[n7];
            ++n7;
        }
        return (float)d;
    }

    public double[] hv2ab(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = 1;
        while (n6 < n2) {
            int n7 = 1 & n5 / 2;
            int n8 = 1 & (n5 ^ n7);
            if (n8 == 0) {
                if (n7 == 1) {
                    n3 = n6 - 1 - n3;
                    n4 = n6 - 1 - n4;
                }
                int n9 = n3;
                n3 = n4;
                n4 = n9;
            }
            n3 += n6 * n7;
            n4 += n6 * n8;
            n5 /= 4;
            n6 *= 2;
        }
        double[] dArray = new double[]{((float)n3 + 0.5f) / (float)(n2 / 2) - 1.0f, ((float)n4 + 0.5f) / (float)(n2 / 2) - 1.0f};
        return dArray;
    }

    public void drawHorizontalScale(int n, int n2, int n3, int n4, float f, float f2, float f3, boolean bl) {
        this.colorMode(3, 1.5f);
        this.noStroke();
        int n5 = 0;
        while (n5 <= n3) {
            this.fill(1.0f - 1.0f * (float)n5 / (float)n3, 1.25f, 1.25f);
            this.rect(n5 + n, n2, 1.0f, n4 - 20);
            ++n5;
        }
        this.colorMode(1, 255.0f);
        this.fill(0);
        this.stroke(0);
        this.textFont(this.buttonfont);
        this.textAlign(3, 102);
        this.text("Percent of incident flux exiting via patch", n + n3 / 2, n2);
        this.textFont(this.captionfont);
        float f4 = 0.0f;
        while (f4 <= 1.1f) {
            if (bl) {
                this.text(String.valueOf(BSDFViewer.nfc((float)(BSDFViewer.pow((float)10.0f, (float)((f4 - 1.0f) * f3)) * f2), (int)4).substring(0, 5)) + "%", f4 * (float)n3 + (float)n, n2 + n4);
            } else {
                this.text(String.valueOf(BSDFViewer.nfc((float)(f + (f2 - f) * f4), (int)4).substring(0, 4)) + "%", f4 * (float)n3 + (float)n, n2 + n4);
            }
            this.line(f4 * (float)n3 + (float)n, n2, f4 * (float)n3 + (float)n, n2 + n4 - 21);
            f4 += 0.1f;
        }
    }

    public void drawVerticalScale(int n, int n2, int n3, int n4, float f, float f2, float f3, boolean bl) {
        this.colorMode(3, 1.5f);
        this.noStroke();
        int n5 = 0;
        while (n5 <= n4) {
            this.fill(1.0f * (float)n5 / (float)n4, 1.25f, 1.25f);
            this.rect(n, n2 + n5, n3, 1.0f);
            ++n5;
        }
        this.colorMode(1, 255.0f);
        this.fill(0);
        this.stroke(0);
        this.textFont(this.buttonfont);
        this.textAlign(3, 102);
        this.rotate(BSDFViewer.radians((float)-90.0f));
        if (this.dataformat.equals("TensorTree4")) {
            this.text("BSDF Value", -n2 - n4 / 2, n);
        } else {
            this.text("Percent of Incident Flux Exiting Patch", -n2 - n4 / 2, n);
        }
        this.rotate(BSDFViewer.radians((float)90.0f));
        this.textFont(this.captionfont);
        this.textAlign(37, 3);
        float f4 = 0.0f;
        while (f4 <= 1.1f) {
            if (bl) {
                this.text(BSDFViewer.nfc((float)(BSDFViewer.pow((float)10.0f, (float)((f4 - 1.0f) * f3)) * f2), (int)4).substring(0, 5), n3 + n + 3, (float)n2 + (float)n4 * (1.0f - f4));
            } else {
                this.text(BSDFViewer.nfc((float)(f + (f2 - f) * f4), (int)4).substring(0, 4), n3 + n + 3, (float)n2 + (float)n4 * (1.0f - f4));
            }
            this.line(n, f4 * (float)n4 + (float)n2, n + n3 - 1, f4 * (float)n4 + (float)n2);
            f4 += 0.1f;
        }
    }

    public void showError(String string) {
        BSDFViewer.println((String)string);
        this.textFont(this.buttonfont);
        this.textLeading(18.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(250.0f, 200.0f, 500.0f, 200.0f);
        this.fill(0);
        this.stroke(0);
        this.textAlign(37, 101);
        this.text(string, 300.0f, 250.0f);
        this.delay(1000);
    }

    public void Help() {
        this.textFont(this.helpfont);
        this.textLeading(18.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(this.ihX - this.ihW / 4 - 6, this.ihY - this.ihH * 1 / 3 - 6, 230.0f, 62.0f);
        this.rect(PApplet.parseInt((float)((float)this.ohX - (float)this.ohW * 0.3f)) - 6, PApplet.parseInt((float)((float)this.ohY - (float)this.ohH * 0.3f)) - 6, 260.0f, 62.0f);
        this.rect(795.0f, 635.0f, 165.0f, 42.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.textAlign(37, 101);
        this.text("Click in this hemisphere to change the\nincident direction. The yellow patch\nindicates the current incident patch.", this.ihX - this.ihW / 4, this.ihY - this.ihH * 1 / 3);
        this.text("The outgoing (reflectance/transmittance)\ndistribution is shown in this hemisphere.\nClick on a patch to see its numerical value.", PApplet.parseInt((float)((float)this.ohX - (float)this.ohW * 0.3f)), PApplet.parseInt((float)((float)this.ohY - (float)this.ohH * 0.3f)));
        this.text("BSDF Viewer version 1.3\nMade by these folks", 800.0f, 640.0f);
        this.arrow(930, 668, 1000, 680);
        this.arrow(PApplet.parseInt((float)((float)this.ohX + (float)this.ohW * 0.28f)), this.ohY - this.ohH / 2 - 40, this.ohX + 132, this.ohY - this.ohH / 2 - 20);
        this.arrow(PApplet.parseInt((float)((float)this.ohX + (float)this.ohW * 0.28f)), this.ohY - this.ohH / 2 - 40, this.ohX - 108, this.ohY - this.ohH / 2 - 20);
        this.text("Click the arrows to cycle through\nreflectance/transmission, front/back,\nand Visible/NIR data in the BSDF", PApplet.parseInt((float)((float)this.ohX + (float)this.ohW * 0.28f + 5.0f)), this.ohY - this.ohH / 2 - 47);
        this.strokeWeight(3.0f);
        this.arrow(220, 40, 170, 20);
        this.textAlign(37, 101);
        this.text("Click to load a BSDF file.  The file must be LBNL Window xml\nformat and must have the LBNL/Klems Full angle basis.", 225.0f, 33.0f);
        this.textAlign(37, 3);
        this.arrow(220, 85, 170, 55);
        this.text("Save an image screen capture of this window.", 225.0f, 85.0f);
        this.arrow(220, 112, 155, 96);
        this.text("Display patch numbers on the projected hemispheres.", 225.0f, 112.0f);
        this.arrow(220, 138, 155, 119);
        this.text("Select the type of projection", 225.0f, 138.0f);
        this.arrow(220, 163, 155, 142);
        this.text("Change between linear and log scales.", 225.0f, 163.0f);
        this.arrow(220, 190, 155, 171);
        this.arrow(220, 190, 155, 191);
        this.text("Adjust the color scale extents.", 225.0f, 190.0f);
        this.strokeWeight(1.0f);
        this.RA.display();
        this.LA.display();
    }

    public void arrow(int n, int n2, int n3, int n4) {
        this.line(n, n2, n3, n4);
        this.pushMatrix();
        this.translate(n3, n4);
        float f = BSDFViewer.atan2((float)(n - n3), (float)(n4 - n2));
        this.rotate(f);
        this.line(0.0f, 0.0f, -8.0f, -8.0f);
        this.line(0.0f, 0.0f, 8.0f, -8.0f);
        this.popMatrix();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "BSDFViewer"});
    }

    class Button {
        int x;
        int y;
        int w;
        int h;
        String tex1;
        String tex2;
        String tex;
        int basecolor;
        int highlightcolor;
        int currentcolor;
        boolean over = false;
        boolean pressed = false;
        boolean state = false;
        PFont bFont;

        Button() {
        }

        public boolean pressed() {
            if (this.over()) {
                this.state = !this.state;
            }
            this.tex = this.state ? this.tex2 : this.tex1;
            return this.over();
        }

        public boolean over() {
            return true;
        }

        public boolean overRect(int n, int n2, int n3, int n4) {
            return BSDFViewer.this.mouseX >= n && BSDFViewer.this.mouseX <= n + n3 && BSDFViewer.this.mouseY >= n2 && BSDFViewer.this.mouseY <= n2 + n4;
        }

        public void select() {
            this.state = true;
            this.currentcolor = this.highlightcolor;
        }

        public void deselect() {
            this.state = true;
            this.currentcolor = this.basecolor;
        }
    }

    class ChangeTextButton
    extends Button {
        ChangeTextButton(int n, int n2, int n3, int n4, int n5, int n6, String string, String string2, PFont pFont) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.tex1 = string;
            this.tex2 = string2;
            this.tex = this.tex1;
            this.bFont = pFont;
        }

        public boolean over() {
            if (this.overRect(this.x, this.y, this.w, this.h)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            BSDFViewer.this.stroke(0);
            BSDFViewer.this.fill(this.currentcolor);
            BSDFViewer.this.rect(this.x, this.y, this.w, this.h);
            BSDFViewer.this.fill(0);
            BSDFViewer.this.textFont(this.bFont);
            BSDFViewer.this.textAlign(37, 3);
            BSDFViewer.this.text(this.tex, this.x + 5, this.y + this.h / 2);
        }
    }

    class LArrowButton
    extends Button {
        LArrowButton(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
        }

        public boolean over() {
            if (this.overRect(this.x, this.y, this.w, this.h)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            BSDFViewer.this.stroke(0);
            BSDFViewer.this.fill(this.currentcolor);
            BSDFViewer.this.triangle(this.x, this.y + this.h / 2, this.x + this.w, this.y + this.h, this.x + this.w, this.y);
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BSDFViewer.this.redraw();
        }
    }

    class RArrowButton
    extends Button {
        RArrowButton(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
        }

        public boolean over() {
            if (this.overRect(this.x, this.y, this.w, this.h)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            BSDFViewer.this.stroke(0);
            BSDFViewer.this.fill(this.currentcolor);
            BSDFViewer.this.triangle(this.x, this.y, this.x, this.y + this.h, this.x + this.w, this.y + this.h / 2);
        }
    }

    class RectButton
    extends Button {
        RectButton(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
        }

        public boolean over() {
            if (this.overRect(this.x, this.y, this.w, this.h)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            BSDFViewer.this.stroke(0);
            BSDFViewer.this.fill(this.currentcolor);
            BSDFViewer.this.rect(this.x, this.y, this.w, this.h);
        }
    }

    class TextButton
    extends Button {
        TextButton(int n, int n2, int n3, int n4, int n5, int n6, String string, PFont pFont) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.tex1 = string;
            this.tex2 = string;
            this.tex = this.tex1;
            this.bFont = pFont;
        }

        public boolean over() {
            if (this.overRect(this.x, this.y, this.w, this.h)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            BSDFViewer.this.stroke(0);
            BSDFViewer.this.fill(this.currentcolor);
            BSDFViewer.this.rect(this.x, this.y, this.w, this.h);
            BSDFViewer.this.fill(0);
            BSDFViewer.this.textFont(this.bFont);
            BSDFViewer.this.textAlign(37, 3);
            BSDFViewer.this.text(this.tex, this.x + 5, this.y + this.h / 2);
        }
    }
}

