#!/usr/bin/perl -w
# RCSid $Id: optics2rad.pl,v 1.1 2013/11/20 18:23:02 greg Exp $
#
# Convert Optics 5 output to correct Radiance input
#
use strict;
my $windoz = ($^O eq "MSWin32" or $^O eq "MSWin64");
if ($#ARGV < 0) {
	print STDERR "Usage: optics2rad optics.mat ..\n";
	exit 1;
}
my $optf =
q[void glass $(name)_glass] . "\n0\n0\n3 " .
q[${Rtn} ${Gtn} ${Btn}] . "\n\n" .
q[void BRTDfunc $(name)_front] . "\n10\n" .
q[ ${fRrho} ${fGrho} ${fBrho}] . "\n" .
q[ ${Rtau} ${Gtau} ${Btau}] . "\n" .
" 0 0 0\n .\n0\n9 0 0 0 0 0 0 0 0 0\n\n" .
q[void BRTDfunc $(name)_back] . "\n10\n" .
q[${bRrho} ${bGrho} ${bBrho}] . "\n" .
q[${Rtau} ${Gtau} ${Btau}] . "\n" .
" 0 0 0\n .\n0\n9 0 0 0 0 0 0 0 0 0\n" ;

print "# Output generated by optics2rad from @ARGV\n";
if (! $windoz ) {
	system q{sed -e '/^[^#]/d' -e '/^$/d' } . "@ARGV" ;
}
my $outf =
q[void glass $(name)] . "\n0\n0\n" .
q[3 ${Rtn} ${Gtn} ${Btn}] . "\n\n" ;

if ($windoz) {
	system "rcalc -l -e \"abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)\" " .
		"-e \"lum(r,g,b):.265*r+.670*g+.065*b\" " .
		"-e \"trans=lum(Rtau,Gtau,Btau)\" " .
		"-e \"rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)\" " .
		"-e \"cond=0.005-abs(rfront-rback)\" " .
		"-i \"$optf\" -o \"$outf\" @ARGV" ;
} else {
	system "rcalc -l -e 'abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)' " .
		"-e 'lum(r,g,b):.265*r+.670*g+.065*b' " .
		"-e 'trans=lum(Rtau,Gtau,Btau)' " .
		"-e 'rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)' " .
		"-e 'cond=0.005-abs(rfront-rback)' " .
		"-i '$optf' -o '$outf' @ARGV" ;
}
$outf =
q[void BRTDfunc $(name)] . "\n" .
q[10 rR_clear rG_clear rB_clear] . "\n" .
q[${Rtau}*tR_clear ${Gtau}*tG_clear ${Btau}*tB_clear] .
"\n0 0 0 window.cal\n0\n" .
"15 0 0 0 0 0 0 0 0 0\n" .
q[${fRrho} ${fGrho} ${fBrho}] . "\n" .
q[${bRrho} ${bGrho} ${bBrho}] . "\n\n" ;

if ($windoz) {
	system "rcalc -l -e \"abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)\" " .
		"-e \"lum(r,g,b):.265*r+.670*g+.065*b\" " .
		"-e \"trans=lum(Rtau,Gtau,Btau)\" " .
		"-e \"rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)\" " .
		"-e \"cond=and(trans-.645, not(0.005-abs(rfront-rback)))\" " .
		"-i \"$optf\" -o \"$outf\" @ARGV" ;
} else {
	system "rcalc -l -e 'abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)' " .
		"-e 'lum(r,g,b):.265*r+.670*g+.065*b' " .
		"-e 'trans=lum(Rtau,Gtau,Btau)' " .
		"-e 'rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)' " .
		"-e 'cond=and(trans-.645, not(0.005-abs(rfront-rback)))' " .
		"-i '$optf' -o '$outf' @ARGV" ;
}
$outf =
q[void BRTDfunc $(name)] . "\n" .
"10 rR_bronze rG_bronze rB_bronze\n" .
q[${Rtau}*tR_bronze ${Gtau}*tG_bronze ${Btau}*tB_bronze] .
"\n0 0 0 window.cal\n0\n" .
"15 0 0 0 0 0 0 0 0 0\n" .
q[${fRrho} ${fGrho} ${fBrho}] . "\n" .
q[${bRrho} ${bGrho} ${bBrho}] . "\n\n";

if ($windoz) {
	system "rcalc -l -e \"abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)\" " .
		"-e \"lum(r,g,b):.265*r+.670*g+.065*b\" " .
		"-e \"trans=lum(Rtau,Gtau,Btau)\" " .
		"-e \"rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)\" " .
		"-e \"cond=and(not(trans-.645), not(0.005-abs(rfront-rback)))\" " .
		"-i \"$optf\" -o \"$outf\" @ARGV" ;
} else {
	system "rcalc -l -e 'abs(x):if(x,x,-x);and(a,b):if(a,b,a);not(x):if(x,-1,1)' " .
		"-e 'lum(r,g,b):.265*r+.670*g+.065*b' " .
		"-e 'trans=lum(Rtau,Gtau,Btau)' " .
		"-e 'rfront=lum(fRrho,fGrho,fBrho);rback=lum(bRrho,bGrho,bBrho)' " .
		"-e 'cond=and(not(trans-.645), not(0.005-abs(rfront-rback)))' " .
		"-i '$optf' -o '$outf' @ARGV" ;
}
