# run a 1compdv simulation from a single point, evaluate DGP and Illum for 2 view directions
raytraverse -c rayt.cfg skyrun directskyrun evaluate
# create hdr heatmaps
raytraverse -c rayt.cfg pull


pcompos -a 1 dgp_view_0* > dgp.hdr
falsecolor -ip dgp.hdr -pal pm3d -l DGP -m 1 -s 1 -n 10 > dgp_fc.hdr
ra_tiff -z dgp_fc.hdr dgp.tif
rm dgp_fc.hdr


# inspect result object
raytraverse pull -lr results.npz --info

# create tsv txt files for each view
raytraverse pull -lr results.npz -col 'metric view' -ofiles test

# pad to 8760 data
raytraverse pull -lr results.npz -col 'metric view' -ofiles test8760 -skyfill office/skydata.npz

# look at 12pm each day for 1 view
raytraverse pull -lr results.npz -viewfilter 0 -skyfilter 12:8760:12 -skyfill office/skydata.npz

# calculate percent of daylight hours with perceptible glare
raytraverse pull -lr results.npz -metricfilter dgp --no-header --no-rowlabel -col view | rcalc -e '$1=if($1-.35,1,0);$2=if($2-.35,1,0)' | total -m