# sample a static sky scene according to luminance variance and generate an un-interpolated image for 1 view direction
raytraverse -c rayt.cfg  sourcerun images
# apply interpolation to the same sampling
raytraverse -c rayt.cfg images -basename inter -interpolate high
# apply a scene detail (material, normal, distance) aware interpolation to the same sampling
raytraverse -c rayt.cfg images -basename context -interpolate highc
# resample static scene according to luminance and scene details then interpolate result
raytraverse -c rayt.cfg sourceengine -accuracy .125 sourcerun --overwrite --scenedetail images -basename detail -interpolate high


pcond -h -v- context_may3pm-0000_pt-0.6_1.0_1.2_vd-1.0_0.0_0.0.hdr > context_may3pm.pcd
pcond -h -v- default_may3pm-0000_pt-0.6_1.0_1.2_vd-1.0_0.0_0.0.hdr > default_may3pm.pcd
pcond -h -v- detail_may3pm-0000_pt-0.6_1.0_1.2_vd-1.0_0.0_0.0.hdr > detail_may3pm.pcd
pcond -h -v- inter_may3pm-0000_pt-0.6_1.0_1.2_vd-1.0_0.0_0.0.hdr > inter_may3pm.pcd

ra_tiff -z context_may3pm.pcd context_may3pm.tif
ra_tiff -z default_may3pm.pcd default_may3pm.tif
ra_tiff -z detail_may3pm.pcd  detail_may3pm.tif
ra_tiff -z inter_may3pm.pcd   inter_may3pm.tif

rm context_may3pm.pcd
rm default_may3pm.pcd
rm detail_may3pm.pcd
rm inter_may3pm.pcd

