#!/usr/bin/env python
import numpy as np

from raytraverse import api

from raytraverse.integrator import SensorIntegrator
from raytraverse.lightfield import SensorPlaneKD, SunSensorPlaneKD


def reload_integrator(scn, pm):

    # reload lightplane from file structure
    sunlp = SunSensorPlaneKD(scn, None, pm, "sensor_suns_sun")


    # declare sun only integrator
    itg = SensorIntegrator(sunlp, ptype=("sun",))
    return itg


def main():
    scn, pm, skyd = api.auto_reload("office", "plane.rad", ptres=.5)
    itg = reload_integrator(scn, pm)
    # unmasked zonal evaluation
    zlr = itg.zonal_evaluate(skyd, pm, datainfo=False)
    zlr.write("sunresults_full.npz")



if __name__ == '__main__':
    main()