%% Function to antialias the baked lightmap
% Giulio Antonutto / ARUP / October 2008 
% CODE IS BETA! USE AT YOUR OWN RISK.

function border_C(tex,res_i,res_j,pic_name,border)


tex_R = reshape(tex(:,1),res_j,res_i);
mask_R = (tex_R == 0);
tex_AR = zeros(size(tex_R));

tex_G = reshape(tex(:,2),res_j,res_i);
mask_G = (tex_G == 0);
tex_AG = zeros(size(tex_G));

tex_B = reshape(tex(:,3),res_j,res_i);
mask_B = (tex_B == 0);
tex_AB = zeros(size(tex_B));

mask = mask_R.*mask_G.*mask_B;
clear tex_R mask_R
clear tex_G mask_G
clear tex_B mask_B
disp('Working on RED channel');

tex_R = reshape(tex(:,1),res_j,res_i);
for x = 1:border

for ri = 1:res_j
    for rj = 1:res_i
     if (ri <= 1)
        if (rj <= 1)
        tex_AR(ri,rj) = max(max(tex_R(ri:ri+1,rj:rj+1)));
        elseif (rj > res_i - 1)
        tex_AR(ri,rj) = max(max(tex_R(ri:ri+1,rj-1:rj)));            
        else
        tex_AR(ri,rj) = max(max(tex_R(ri:ri+1,rj-1:rj+1)));
        end
 
     elseif (ri > res_j-1)
        if (rj <= 1)
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri,rj:rj+1)));
        elseif (rj >  res_i - 1)
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri,rj-1:rj)));            
        else
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri,rj-1:rj+1)));
        end
 
     else
        if (rj <= 1)
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri+1,rj:rj+1)));
        elseif (rj > res_i - 1)
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri+1,rj-1:rj)));            
        else
        tex_AR(ri,rj) = max(max(tex_R(ri-1:ri+1,rj-1:rj+1)));
        end
     end
    end
end
tex_R = tex_AR;

end
tex_AR  = reshape((tex_AR .* mask),res_j*res_i,1);
clear tex_R


disp('Working on GREEN channel');

tex_G = reshape(tex(:,2),res_j,res_i);
tex_AG = zeros(size(tex_G));
mask_G = (tex_G == 0);
for x = 1:border

for gi = 1:res_j
    for gj = 1:res_i
     if (gi <= 1)
        if (gj <= 1)
        tex_AG(gi,gj) = max(max(tex_G(gi:gi+1,gj:gj+1)));
        elseif (gj >  res_i - 1)
        tex_AG(gi,gj) = max(max(tex_G(gi:gi+1,gj-1:gj)));            
        else
        tex_AG(gi,gj) = max(max(tex_G(gi:gi+1,gj-1:gj+1)));
        end
 
     elseif (gi > res_j-1)
        if (gj <= 1)
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi,gj:gj+1)));
        elseif (gj >  res_i - 1)
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi,gj-1:gj)));            
        else
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi,gj-1:gj+1)));
        end
 
     else
        if (gj <= 1)
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi+1,gj:gj+1)));
        elseif (gj >  res_i - 1)
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi+1,gj-1:gj)));            
        else
        tex_AG(gi,gj) = max(max(tex_G(gi-1:gi+1,gj-1:gj+1)));
        end
     end
    end
end
tex_G = tex_AG;

end

tex_AG  = reshape(tex_AG .* mask,res_j*res_i,1);
clear tex_G
 
disp('Working on BLUE channel');
 
tex_B = reshape(tex(:,3),res_j,res_i);
tex_AB = zeros(size(tex_B));
mask_B = (tex_B == 0);
for x = 1:border
 for bi = 1:res_j
    for bj = 1:res_i
     if (bi <= 1)
        if (bj <= 1)
        tex_AB(bi,bj) = max(max(tex_B(bi:bi+1,bj:bj+1)));
        elseif (bj >  res_i - 1)
        tex_AB(bi,bj) = max(max(tex_B(bi:bi+1,bj-1:bj)));            
        else
        tex_AB(bi,bj) = max(max(tex_B(bi:bi+1,bj-1:bj+1)));
        end
 
     elseif (bi > res_j-1)
        if (bj <= 1)
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi,bj:bj+1)));
        elseif (bj >  res_i - 1)
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi,bj-1:bj)));            
        else
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi,bj-1:bj+1)));
        end
 
     else
        if (bj <= 1)
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi+1,bj:bj+1)));
        elseif (bj >  res_i - 1)
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi+1,bj-1:bj)));            
        else
        tex_AB(bi,bj) = max(max(tex_B(bi-1:bi+1,bj-1:bj+1)));
        end
     end
    end
end
tex_B = tex_AB;
end
tex_AB  = reshape(tex_AB .* mask,res_j*res_i,1);
clear tex_B



%%
% Combine together matrixes and clear
tex_A = tex + [tex_AR tex_AG tex_AB];
save -ascii tex_A.dat tex_A
clear tex tex_AR tex_AG tex_AB;

%% Save the data in an image
%  
disp('Creating image and finishing');
unix(sprintf('pvalue -r -o -h -H -da -x %d -y %d tex_A.dat > tex.pic.0',res_i,res_j));
unix(sprintf('protate -r tex.pic.0 > %s.pic',pic_name));
unix(sprintf('ra_tiff -z -e -3 %s.pic %s.tif',pic_name,pic_name));
unix(sprintf('falsecolor -lw 0 -m 179 -s 1000 -i %s.pic > %s.lum.pic',pic_name,pic_name));
unix('rm  tex_A.dat');







