%% Function to create a baked lightmap
% Giulio Antonutto / ARUP / October 2008 
% CODE IS BETA! USE AT YOUR OWN RISK.
%
% This piece of code does:
% * Open and inport an OBJ file[1]
% * Open and use a octree file
% * save the lightmap filtered[2] with a given name as pic and tif
%
% The idea 
% 
%
% Note: 
% [1] The parser is a modified version of a great piece of code by 
% W.S. Harwin and Anders Sandberg
% [2] This filter can be largely be improved.



function radtex_c4d(obj_name, oct_name, pic_name, res_i, res_j, Off, cores, border )

if nargin <1 
  disp('Usage: radtex_c4d(obj, oct, pic, Res I , Res J, Off, N. Cores,  border)')  
end


%% Inport UV and Vertexes
% import triangles and UV map matrixes
[PP QQ E] = load_obj_c4d(obj_name);


%%
% Check on the obj, the file MUST contain triangles
switch E
case 0

%% Calculate texture
% A grid is created in uv coordinates, based on resolution
% and points are filtered if outside of the UV triangle P
% Next lines create the original patter from 0 to 1 in fractions over i and j

pi = zeros(1,res_i);
ti = zeros(1,res_i);
for i = 1:res_i
    pi(i) = (1/res_i)*i;
    ti(i) = i;
end

pj = zeros(1,res_j);
tj = zeros(1,res_j);
for j = 1:res_j;
    pj(j) = (1/res_j)*j;
    tj(j) = j;

end

%%
% this takes the original pattern and assamble it in a 
% matrix G with size [(res_i*res_j), 3]
% the third column is an index used for assembling back the rendered
% triangles
G =zeros(res_i*res_j,3);
G(:,2) = repmat(pj',res_i,1);
G(:,1) = reshape((repmat(pi',1,res_j))',res_j*res_i,1);
G(:,3) = 1:size(G,1);

tex =zeros(res_i*res_j,3);

%% Main cycle through each triangle UV
GRID = [];
HH = [];


for ti = 1:size(PP,1)/3
    disp(sprintf('Starting triangle: %d', ti));
    Q = [QQ(3*(ti-1)+1,1:3);QQ(3*(ti-1)+2,1:3);QQ(3*(ti-1)+3,1:3) ];
    P = [PP(3*(ti-1)+1,1:3);PP(3*(ti-1)+2,1:3);PP(3*(ti-1)+3,1:3) ];
%% Initial selection of points which are inside one of the UV triangle
clear H T1 T2 T3 PG;

%% Original Matlab routine
H = G(inpolygon(G(:,1),G(:,2),P(:,1),P(:,2)),:);
HH = [HH; H];



%%
% Check that H is not null and go further
switch isempty(H);

case 0
%% Affine transformation Matrix
% Define two triangle side vectors
P_a = [P(3,1)-P(2,1);P(3,2)-P(2,2);0];
P_b = [P(1,1)-P(2,1);P(1,2)-P(2,2);0];
Q_a = [Q(3,1)-Q(2,1);Q(3,2)-Q(2,2);Q(3,3)-Q(2,3)];
Q_b = [Q(1,1)-Q(2,1);Q(1,2)-Q(2,2);Q(1,3)-Q(2,3)];
%%
% Calculate Normal vectors and normalize
Pn = P(1,:)'+ (cross(P_a,P_b))/ norm(cross(P_a,P_b));
Qn = Q(1,:)'+ (cross(Q_a,Q_b)) / norm(cross(Q_a,Q_b));
Qnv = (cross(Q_a,Q_b)) / norm(cross(Q_a,Q_b));
%%
% Reorganize a matrix Tp
Pb = P';
Pb(:,4) = Pn;
Tp = Pb(:,2:4) - repmat(Pb(:,1),1,3);
%%
% Reorganize a matrix Tq
Qb = Q';
Qb(:,4) = Qn;
Tq = Qb(:,2:4) - repmat(Qb(:,1),1,3);
%%
% Invert matrix Tp
Tp_inv = inv(Tp);
%%
% Find M 
M = Tq * Tp_inv;
% Populate an empty matrix for Mt
Mt = zeros(4,4,3);
% Fills Mt with data
for i = 1:3
    Mt(1:3,1:3,i) = M;
    Mt(4,4,i) = 1;
    Mt(1:3,4,i) = Q(i,1:3);
end
P0 = [P(1,:) 1];
Hi = [H(:,1:2) zeros(size(H,1),1) ones(size(H,1),1)];

Hi0 = Hi;
Hi0(:,1) = Hi(:,1) - P0(1,1);
Hi0(:,2) = Hi(:,2) - P0(1,2);
Hi0(:,3) = Hi(:,3) - P0(1,3);

H2= Mt(:,:,1) * Hi0' ;
H3 = H2';

% mind that these points are not on the surface, a little offset is applied
H4 = H3(:,1:3) + repmat(Qnv'*Off,size(H3,1),1);


%%
% The final grid for rtrace:
H4(:,4:6) = repmat(-1*Qnv',size(H3,1),1);
GRID = [GRID; H4];


disp(sprintf('Done triangle: %d', ti));

case 1
disp(sprintf('Done triangle: %d but empty', ti));
%%
% end switches
end



%%
% end ciclo for each triangle
end


%%
% Saving the grid of points and rendering on each core used
disp('Saving Grid for Calculation');
unix(sprintf('mv grid.all %s.grid', pic_name));


TGRID = [];
processes = floor(size(GRID,1)/cores);

%%
% Save each grid in a file for multicore rendering  
for rtr=1:cores-1
TGRID = GRID(1+(rtr-1)*processes:(rtr)*processes, 1:6);

s = ['save -ascii grid.' int2str(rtr) '.tmp TGRID '];
eval(s);
clear TGRID;


%%
% last cores with the rest, grid is slightly larger
end
TGRID = GRID(1+(cores-1)*processes:size(GRID,1), 1:6);
s = ['save -ascii grid.' int2str(cores) '.tmp TGRID '];
eval(s);





disp(sprintf('Now Rendering Grid on %d Cores',cores));
%write a file for radiance batch rendering
fid1 = fopen('Mrtrace','w');
fprintf(fid1,'#! /bin/tcsh -f \n rm ill.tmp \n');


for rtr=1:cores    
           fprintf(fid1,'rtrace -w- -h- -ab 1 -aa 0 -ad 256 -as 128 -u -ds .1 -dj .6  %s < grid.%d.tmp | rcalc -e ''$1=$1+0.0001;$2=$2+0.0001;$3=$3+0.0001;'' > ill.%d.tmp & \n' , oct_name, rtr, rtr);
end

fprintf(fid1,'wait \n');
for rtr=1:cores
fprintf(fid1,'cat ill.%d.tmp >> ill.tmp \n' , rtr);
end
status = fclose(fid1);

unix('chmod u+x Mrtrace');



% Render the grid and assemble back results:
unix('./Mrtrace');

%%
% Clear some variables used before:
clear GRID TGRID H4 G H PP QQ Hi Hi0 H2 H3 H4;



disp('Loading back simulation results...');
values = load('ill.tmp');

disp('Reassembling Grid with zero values');
tex(HH(:,3),1)= values(:,1);
tex(HH(:,3),2)= values(:,2);
tex(HH(:,3),3)= values(:,3);

clear values;


%%
% Filtering the voids to antialias image 
% Filter can be improved...
disp(sprintf('Filtering texture'));
border_C(tex,res_i,res_j,pic_name,border);


%%
% Remove stuff left over
unix('rm tex.pic.0');
unix('rm ill.tmp');
unix('rm ill.*.tmp');
unix('rm grid.*.tmp');
unix('rm Mrtrace');


%%
% Error if the obj is not triangulated:
%switch E, linea 54 o circa
case 1
error(['Did you triangulate the file ' obj_name ' ?!'])
end











